% % % % % % % % % % % % % % % % % % % % % % % % %
%                                               %
%       HOW TO EDIT DATA FROM A .FIG FILE       %
%                                               %
%       martella, Oct. 19 2011                  %
%                                               %
% % % % % % % % % % % % % % % % % % % % % % % % %


% open
close all
clear all
open('sv_27_60reg.fig'); 
h = gcf;


% find the line objects in the figure: this will return all the lines in the current figure
line = findall(h, 'Type', 'Line');


% extract X and Y data values from the first line
% x = get(line(1), 'xdata');
y = get(line(10), 'ydata');

yy = 1/y(1) .* y;

figure1 = figure('XVisual',...
    '0x99 (TrueColor, depth 24, RGB mask 0xff0000 0xff00 0x00ff)');
% Create axes
axes('Parent',figure1,'YScale','log','YMinorTick','on','YMinorGrid','on',...
    'FontSize',14);
box('on');
grid('on');
hold('all');
semilogy(yy,'MarkerFaceColor',[0 0 0],'MarkerSize',15,'Marker','o',...
    'LineStyle','none',...
    'Color',[0 0 0]);
% Create textbox
annotation(figure1,'textbox',[0.29 0.8162 0.6066 0.08788],...
    'String',{'IS = 0, BS = 13, \alpha = 1e-2'},...
    'FontWeight','bold',...
    'FontSize',20,...
    'FontName','Arial',...
    'FitBoxToText','off',...
    'LineStyle','none',...
    'BackgroundColor',[1 1 1]);

h = findobj(gca,'Type','line')
x=get(h,'Xdata')
y=get(h,'Ydata')

