#!/usr/bin/env python

import sys
import glob


if sys.version_info < (2, 7):
    print >> sys.stderr, "ERROR: dimer requires python 2.7 or greater"
    sys.exit()

# Automatically download setuptools if not available
from distribute_setup import use_setuptools
use_setuptools()

from setuptools import *

# ---- Commands -------------------------------------------------------------

#from distutils.core import Command

# Use build_ext from Cython
command_classes = {}

# Use build_ext from Cython if found
try:
    import Cython.Distutils
    command_classes['build_ext'] = Cython.Distutils.build_ext
except:
    pass

# Run 2to3 builder if we're on Python 3.x, from
#   http://wiki.python.org/moin/PortingPythonToPy3k
try:
    from distutils.command.build_py import build_py_2to3 as build_py
except ImportError:
    # 2.x
    from distutils.command.build_py import build_py
command_classes['build_py'] = build_py

setup(
    name='dimer',
    description='Deep Models for Expression and Regulation',
    author='Olgert Denas (Taylor Lab)',
    author_email="gertidenas@gmail.com",
    url='https://bitbucket.org/gertidenas/dimer',
    version=0.1,
    packages=['dimer', 'dimer.genome', 'dimer.nnet', 'dimer.nnet.cnninv'],
    package_dir={'dimer': 'lib'},
    scripts=glob.glob("bin/*py"),
    ext_modules=[Extension("dimer.genome.bed", ["lib/genome/bed.pyx"]),
                 Extension("dimer.genome.peak", ["lib/genome/peak.pyx"])],
    install_requires=['numpy > 1.5', 'pandas == 0.11', 'tables == 3.0.0'],
    cmdclass=command_classes,
    classifiers=['Development Status :: 3 - Alpha',
                 'Environment :: Console',
                 'Programming Language :: Python',
                 'Topic :: Communications :: Email',
                 'Intended Audience :: Science/Research',
                 'License :: Free for non-commercial use',
                 'Natural Language :: English',
                 'Topic :: Scientific/Engineering :: Artificial Intelligence',
                 ]
)
