
import unittest

import numpy as np
rng = np.random.RandomState()
import pandas as pd

from . import adjust_lr


def archive_model(model):
    from .. import archive_tests
    from .. import archive

    with archive_tests.empty_archive(tmp=False) as pdtup:
        path = archive.join(*pdtup)
        model.save(path)
    return path


class TestLr( unittest.TestCase ):
    def test_lrate(self):
        "test adjustment of learning rate"
        self.assertEqual( adjust_lr([4], 0.1), 0.1 )

        self.assertLess( adjust_lr([4, 5], 0.1), 0.1 )
        self.assertEqual( adjust_lr([5, 3], 0.1) , 0.1 )
        self.assertEqual( adjust_lr([5, 5], 0.1) , 0.1 )


    def test_pt(self):
        "test problem types"
        from . import ProblemType as P

        ds = type("FakeDataset", (object,), dict(T=P.classification,
                                                 labels=P.classification,
                                                 shT=P.classification,
                                                 Y=P.regression, shY=P.regression))
        for (a,b) in [("C", P.classification), ("R", P.regression)]:
            self.assertEqual(P.top_layer[a], P.top_layer[b])
            self.assertEqual(P.parse(a), b)

            self.assertEqual(P.ds_out(ds, a), P.ds_out(ds, b))
            self.assertEqual(P.ds_out(ds, a), b)

            if a == "C":
                self.assertEqual(P.ds_nout(ds, a), P.ds_nout(ds, b))
                self.assertEqual(P.ds_nout(ds, a), b)
            self.assertEqual(P.ds_nout(ds, "R"), P.ds_nout(ds, P.regression))
            self.assertEqual(P.ds_nout(ds, "R"), 1)
