
import unittest
import tempfile
from contextlib import contextmanager

import numpy as np
import pandas as pd

import archive


@contextmanager
def empty_archive(dsname="empty", tmp=True):
    from archive import __SPEC_SEP__, __HDF_SUFFIX__, split
    with tempfile.NamedTemporaryFile(suffix="." + __HDF_SUFFIX__, delete=tmp) as fd:
        #yield path, dsname
        yield split( __SPEC_SEP__.join( (fd.name, "empty") ) )


class TestArchive(unittest.TestCase):
    def test_basename(self):
        "testing basename, archname, join, split"
        from archive import basename, archname, join, split

        self.assertEqual(basename("/a/b.h5:ciao"), "ciao")
        self.assertEqual(archname("/a/b.h5:ciao"), "/a/b.h5")

        self.assertEqual( join("/a/b.h5", "ciao"), "/a/b.h5:ciao" )

        self.assertEqual( ("/a/b.h5", "ciao"), split("/a/b.h5:ciao" ) )

    def test_io(self):
        "save and load the same object"
        with empty_archive() as (p, k):
            obj = pd.Series(np.random.rand(5), index=range(5, 10) )
            archive.save_object(p, k, obj)
            ro = archive.load_object(p, k)
            self.assertTrue( np.all(ro.values == obj.values) )
