#!/usr/bin/env python

"""join consecutive semgents of a segmentation with the same metalabel
in a BED4 file. N.B: a segmentation is a partition of a genome region"""

import sys
import logging
import fileinput
from itertools import imap

from dimer import genome, argutils

logging.basicConfig(level=logging.INFO)
lg = logging.getLogger()

if __name__ != '__main__':
    lg.error("this is a script do not import")
    sys.exit(1)

parser = argutils.parser_inst(__doc__)
parser.add_argument("input", type=str,
                    help="Sorted BED4 features")
parser.add_argument("--filler_label", type=str, default=None,
                    help=("If input is not a segmentation, "
                          "fill holes with this label"))

opt = parser.parse_args()

bed_parser = lambda l: genome.parseBED(l, use_score=False)
with open(opt.input) as fd:
    bed_reader = imap(bed_parser, fd)
    bed_reader = genome.join_by_name(bed_reader, fill=opt.filler_label)
    for f in bed_reader:
        print "%s\t%d\t%d\t%s" % f
