
import unittest

from config_spec import CnnModelSpec, AESpec
from .. import archive_tests


#@unittest.skip("for now")
class TestCfg( unittest.TestCase ):
    def setUp(self):
        pass

    def save_load(self, ms):
        with archive_tests.empty_archive() as (arch, dsn):
            ms.archive_dump(arch, dsn)
            self.assertTrue(ms, type(ms)._from_archive(arch, dsn))

    def test_cnnmodelspecIO(self):
        "test that config_specs can save and load"

        self.save_load(CnnModelSpec._make(((60,), ((56, 9),), ((1, 1),), 10)))

    def test_aemodelspecIO(self):
        "test that config_specs can save and load"

        self.save_load(AESpec._make((60, (56, 9, 4, 3), 0.3)))


@unittest.skip("TODO")
class TestExpSpec( unittest.TestCase ):
    def setUp(self):
        pass
