"""
Iterator for the broadPeak and narrowPeak formats
(http://genome.ucsc.edu/FAQ/FAQformat.html#format13
and
https://genome.ucsc.edu/FAQ/FAQformat.html#format12)

Returns
 * (bp) chrom, chromStart, chromEnd, name, score, strand, signal, pval, qval
 * (np) chrom, chromStart, chromEnd, name, score, strand, signal, pval, qval, peak
"""

cdef class BroadPeakReader:
    cdef object f
    def __init__( self, f):
        self.f = f

    def __iter__( self ):
        return self

    def __next__( self ):
        while True:
            line = self.f.readline()
            if not line:
                raise StopIteration()
            if line.isspace():
                continue
            if line[0] == "#":
                continue
            if line[0].isalpha():
                if line.startswith( "track" ) or line.startswith( "browser" ):
                    continue

                feature = line.strip().split()
                if len(feature) != 9:
                    raise "%d fields, (expected 9)" % len(feature)
                chrom = feature[0]
                chrom_start = int(feature[1])
                chrom_end = int(feature[2])
                name = feature[3]
                score = float(feature[4])
                strand = feature[5]
                signal = float(feature[6])

                pval = float(feature[7])
                if pval == "-1": pval = int(pval)
                qval = float(feature[8])
                if qval == "-1": qval = int(qval)

                return chrom, chrom_start, chrom_end, name, score, strand, signal, pval, qval
            else:
                raise "Unexpected input line: %s" % line.strip()

cdef class NarrowPeakReader:
    cdef object f
    def __init__( self, f):
        self.f = f

    def __iter__( self ):
        return self

    def __next__( self ):
        while True:
            line = self.f.readline()
            if not line:
                raise StopIteration()
            if line.isspace():
                continue
            if line[0] == "#":
                continue
            if line[0].isalpha():
                if line.startswith( "track" ) or line.startswith( "browser" ):
                    continue

                feature = line.strip().split()
                if len(feature) != 10:
                    raise "%d fields, (expected 10)" % len(feature)
                chrom = feature[0]
                chrom_start = int(feature[1])
                chrom_end = int(feature[2])
                name = feature[3]
                score = float(feature[4])
                strand = feature[5]
                signal = float(feature[6])
                pval = float(feature[7])
                qval = float(feature[8])
                peak = int(feature[9])

                return chrom, chrom_start, chrom_end, name, score, strand, signal, pval, qval, peak
            else:
                raise "Unexpected input line: %s" % line.strip()
