
import sys, os, random
import unittest
import tempfile
from operator import itemgetter
from functools import partial
import numpy as np

from dimer.genome.frepr import RawFrep

rng = np.random.RandomState()


@unittest.skip("TODO")
class TestTrackFrepr( unittest.TestCase ):
    pass

class TestRawFrep( unittest.TestCase ):
    def setUp(self):
        pass

    def random_rf(self, mll=None):
        if mll is None:
            mll = random.randint(1, 30)
        ml = RawFrep._mtlb_sep.join(map(lambda v: RawFrep._mtlb_frm % v,
                                        np.random.rand(mll)))
        ins = RawFrep._sep.join(("chr%d" % random.randint(1, 24),
                                 str(random.randint(0, 10000)),
                                 str(random.randint(0, 10000)),
                                 ml))
        return ins

    def iter_ln(self, n=1000, min_mll=1):
        for i in range(n):
            mll = random.randint(1, 10)
            line = self.random_rf(mll)
            yield (mll, line)

    def iter_rf(self, n=1000):
        for i, l in self.iter_ln(n):
            rf = RawFrep.from_line(l)
            yield (i, rf)


    def test_instats(self):
        for mll, line in self.iter_ln():
            rf = RawFrep.from_line(line)
            xrf = RawFrep.from_array(rf.chrom, rf.start, rf.end,
                                     np.array(map(float, rf.tup_metalab)))

            self.assertEqual(line, rf.to_raw())
            self.assertEqual(line, xrf.to_raw())
            self.assertEqual(rf.to_raw(), xrf.to_raw())
            print rf
            with self.assertRaises(ValueError):
                if mll > 1:
                    RawFrep.from_line_ec(line.replace(" ", "\t"))
                else:
                    RawFrep.from_line_ec(line.replace("\t", " "))

    def test_nunit(self):
        for mll, rf in self.iter_rf(10):
            self.assertEqual(rf.nunits, mll)

    def test_binarized(self):
        for mll, rf in self.iter_rf(1000):
            mlb = rf.arr_metalab
            blb = rf.binarized("auto", "").arr_metalab

            thr = 0.5 * (np.min(mlb) + np.max(mlb))
            if np.all(mlb == np.min(mlb)):
                thr = 0.0
            for v, bv in zip(mlb, blb):
                self.assertEqual(bv, 0.0 if v <= thr else 1.0)

        rf = RawFrep._make(("chr2", 0, 100, "0.2 0.3 0"))
        self.assertEqual(rf.binarized("auto", "").tup_metalab,
                         ["1", "1", "0"])

        rf = RawFrep._make(("chr2", 0, 100, "0.2 0.3 0"))
        self.assertEqual(rf.binarized("max", "").tup_metalab,
                         ["0", "1", "0"])
        for strat in ("auto", "max"):
            print strat
            rf = RawFrep._make(("chr2", 0, 100, "0 0 0"))
            bx = rf.binarized(strat, "").arr_metalab
            self.assertTrue(np.all(rf.arr_metalab == bx))

            rf = RawFrep._make(("chr2", 0, 100, "1 1 1"))
            bx = rf.binarized(strat, "").arr_metalab
            print rf, bx
            self.assertTrue(np.all(rf.arr_metalab == bx))

        for mll, rf in self.iter_rf(500):
            mlb = rf.arr_metalab
            thr = random.random()
            brf = rf.binarized(thr, "")

            for v, bv in zip(mlb, brf.arr_metalab):
                self.assertEqual(bv, 0.0 if v <= thr else 1.0)
        rf = RawFrep._make(("chr2", 0, 100, "0.3 nan"))
        self.assertEqual(rf.binarized("max", "").tup_metalab, ["", ""])

    def test_digitized(self):
        for mll, rf in self.iter_rf(10):
            nb = random.randint(2, 5)
            drf = rf.digitized(nb, 'n')

            self.assertEqual(rf.chrom, drf.chrom)
            self.assertEqual(rf.start, drf.start)
            self.assertEqual(rf.end, drf.end)
            self.assertEqual(rf.nunits, drf.nunits)

            dx =np.array(map(float, drf.tup_metalab))
            print dx
            self.assertTrue(np.max(dx) < nb)
            self.assertTrue(np.min(dx) >= 0)

    @unittest.skip("TODO")
    def test_keep(self):
        for mll, rf in self.iter_rf(10):
            rf = RawFrep.from_line(line)

            kll = random.randint(0, 10)
            kp = random.sample(mll / 2)
