#!/usr/bin/env python

"""Download feature files from a history in Galaxy.

An API key is needed for authentication
(get it from "Users -> API Keys" in your Galaxy instance)
"""


import os
import sys
import logging
import argparse
import json
import urllib2

logging.basicConfig(level=logging.DEBUG)
log = logging.getLogger()

if __name__ != '__main__':
    log.error("this is a script do not import")
    sys.exit(1)


def comment(f, msg):
    def nf(*args, **kwargs):
        log.info(msg)
        res = f(*args, **kwargs)
        log.info("DONE!")
        return res
    return nf


def get(api_key, url):
    # Do the actual GET.
    url = make_url( api_key, url )
    return json.loads(urllib2.urlopen(url).read())

def make_url(api_key, url, args=None):
    """Adds the API Key to the URL if it's not already there."""

    if args is None:
        args = []
    argsep = '&'
    if '?' not in url:
        argsep = '?'
    if '?key=' not in url and '&key=' not in url:
        args.insert( 0, ( 'key', api_key ) )
    return url + argsep + '&'.join( [ '='.join( t ) for t in args ] )


def datasets_from_history(key, url, state="ok"):
    lst = get(key, url)["state_ids"][state]

parser = argparse.ArgumentParser(
    description=__doc__,
    formatter_class=argparse.ArgumentDefaultsHelpFormatter,
    epilog="Taylor Lab (odenas@emory.edu)")
parser.add_argument("key", type=str, help="An API Key")
parser.add_argument("--history", '-s', type=str, default="",
                    help="History name. If empty your history list will be displayed.")
parser.add_argument("--output", type=str, default=".", help="Output directory")
parser.add_argument("--url", type=str,
                    default="https://main.g2.bx.psu.edu/api/histories",
                    help="Url of the server where Galaxy is running")
opt = parser.parse_args()

if opt.history:
    hdesc = get(opt.key, os.path.join(opt.url, opt.history))
    hcont = get(opt.key, os.path.join(opt.url, opt.history, "contents"))
    print json.dumps(hcont, indent=4)
    #logging.info("contacting %s...", opt.url)
    #print "\n".join(datasets_from_history(opt.key, os.path.join(opt.url, opt.history)))
else:
    print json.dumps(get(opt.key, os.path.join(opt.url, opt.history)),
                     indent=4)
