import sys, os, random
import unittest
import tempfile
from operator import itemgetter
from itertools import imap

from dimer.genome import parseBED, join_by_name

class TestBedops(unittest.TestCase):
    def setUp(self):
        self.p1 = ("chr1\t15\t30\tmp2\t0.5", "chr1\t30\t35\tmp2\t0.1",
                   "chr3\t35\t80\tmp2\t0.5", "chr4\t80\t156\tmp3\t0.5")
        self.p2 = ("chr4\t156\t180\tmp4\t0.5", "chr4\t190\t235\tmp4\t0.1",
                   "chr4\t235\t356\tmp4\t0.5")

        self.pp1 = map(parseBED, self.p1)
        self.pp2 = map(parseBED, self.p2)

    def test_join_werror(self):
        res = list(join_by_name(self.pp1 + self.pp2, fill="fill"))
        print len(res)
        print res
        self.assertEqual("\t".join(map(str, res[0])), ("chr1\t15\t35\tmp2"))
        self.assertEqual("\t".join(map(str, res[1])), ("chr3\t35\t80\tmp2"))
        self.assertEqual("\t".join(map(str, res[2])), ("chr4\t80\t156\tmp3"))
        self.assertEqual("\t".join(map(str, res[3])), ("chr4\t156\t180\tmp4"))
        self.assertEqual("\t".join(map(str, res[4])), ("chr4\t180\t190\tfill"))
        self.assertEqual("\t".join(map(str, res[5])), ("chr4\t190\t356\tmp4"))


    def test_join_cons(self):
        res = list(join_by_name(self.pp1, fill="fill"))
        self.assertEqual("\t".join(map(str, res[0])), ("chr1\t15\t35\tmp2"))
        self.assertEqual("\t".join(map(str, res[1])), ("chr3\t35\t80\tmp2"))
        self.assertEqual("\t".join(map(str, res[2])), ("chr4\t80\t156\tmp3"))

        res = list(join_by_name(imap(parseBED, self.p1),
                                join_key=itemgetter(0, 3, 4)))
        for i, r in enumerate(map(parseBED, self.p1)):
            self.assertEqual(res[i], tuple(r)[:4])


    def _get_bed_file(self, cons=True):
        if not ( hasattr(self, "bfn") and os.path.exists(self.bfn) ):
            with tempfile.NamedTemporaryFile(delete=False) as mfd:
                mfd.write("\n".join(self.p1))
                if not cons:
                    mfd.write("\n".join(self.p2))
        self.bfn = mfd.name

    def test_parsebed(self):
        self._get_bed_file()
        with open(self.bfn) as fd:
            res_sc = map(parseBED, fd)
        with open(self.bfn) as fd:
            for i, line in enumerate(fd):
                c, s, e, n, v = line.rstrip().split("\t")
                self.assertEqual(res_sc[i], [c, int(s), int(e), n, float(v)])

        bg_val = 1.4
        with open(self.bfn) as fd:
            res_bg = map(lambda l: parseBED(l, use_score=False, bg_val=bg_val), fd)
        self.assertEqual(len(res_sc), len(res_bg))

        self.assertTrue(all(map(lambda (a,b): a[:4]==b[:4],
                                zip(res_sc, res_bg))))
        for a in res_bg:
            self.assertEqual(a[4], 1.4)


if __name__ == '__main__':
    unittest.main()


