#!/usr/bin/env python

"""Bin the components of metalabels, by applying np.digitize. metalables are
expected to contain numbers or `nan`. In the latter case the output metalabel
will be substituted to a string of your choice
"""

import sys
import logging
import argparse
import numpy as np
from itertools import imap
from operator import itemgetter
from dimer.argutils import ArgTypes, parser_inst
from dimer.genome import frepr


logging.basicConfig(level=logging.INFO)
lg = logging.getLogger()


if __name__ != '__main__':
    lg.error("this is a script do not import")
    sys.exit(1)

parser = parser_inst(__doc__)
parser.add_argument("input", type=str, nargs="+", help="Input data")
parser.add_argument("nbins", type=ArgTypes.is_pint,
                    help="nr. of levels per label")
parser.add_argument("--suff", type=str, default="=",
                    help="Suffix to metalabels")
parser.add_argument("--nan_symb", type=str, default="n",
                    help=("if any component of a metalabel is a `nan`, "
                          "substitute with this."))
parser.add_argument("--keep", nargs="+", type=ArgTypes.is_uint, default=[],
                    help=("Keep the labels with these indexes. Indexes are 0-based "
                          "Keeps all by default."))
parser.add_argument("--ec", action='store_true', default=False,
                    help=("Check format of the meatlabel"))


opt = parser.parse_args()
if opt.ec:
    rf_factory = frepr.RawFrep.from_line_ec
else:
    rf_factory = frepr.RawFrep.from_line

for fin in opt.input:
    with open(fin) as fd:
        for raw_repr in imap(frepr.RawFrep.from_line, fd):
            new_repr = raw_repr.keep_units(opt.keep).digitized(opt.nbins,
                                                               opt.nan_symb)
            print new_repr.to_raw() + opt.suff
