package gap.graph;

import java.util.Iterator;

import org.jgrapht.graph.SimpleWeightedGraph;

@SuppressWarnings("hiding")
public class GapSimpleWeightedGraph<String, DefaultWeightedEdge> extends SimpleWeightedGraph<String, DefaultWeightedEdge> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public GapSimpleWeightedGraph(Class<? extends DefaultWeightedEdge> edgeClass) {
		super(edgeClass);
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param args
	 */
	public boolean toPrint(){
		Iterator<String> itrv = this.vertexSet().iterator();
		while (itrv.hasNext()) {
			System.out.print(itrv.next()+" ");			
		}
		System.out.println();
		
		Iterator<DefaultWeightedEdge> itre = this.edgeSet().iterator();
		while (itre.hasNext()) {
			DefaultWeightedEdge edge = (DefaultWeightedEdge) itre.next();
			System.out.println(this.getEdgeSource(edge)+" - "+this.getEdgeTarget(edge)+" : "+this.getEdgeWeight(edge));
		}
		return true;
	}
	public boolean reduceWeight(){
		Iterator<DefaultWeightedEdge> itre = this.edgeSet().iterator();
		double totalWeight = 0;
		while (itre.hasNext()) {
			DefaultWeightedEdge edge = (DefaultWeightedEdge) itre.next();
			totalWeight += this.getEdgeWeight(edge);
		}
		//System.out.println(totalWeight);
		itre = this.edgeSet().iterator();
		while (itre.hasNext()) {
			DefaultWeightedEdge edge = (DefaultWeightedEdge) itre.next();
			this.setEdgeWeight(edge, (this.getEdgeWeight(edge) / totalWeight));
			//this.setEdgeWeight(edge, 1);

		}
		return true;
	}
}
