package gap.graph;



import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.jgrapht.graph.SimpleWeightedGraph;
import gap.graph.ChargedEdge;

/**
 * @author Logsiny
 *
 */
public class SimpleWeightedGraphPoint extends SimpleWeightedGraph<PointLabeled,ChargedEdge> {
/* serialVersionUID */
	private static final long serialVersionUID = 1L;
	private static final PointLabeled center = new PointLabeled(200,200,new String(""+0));
	private static final int radius = 160;
/* inherited construction method */
	public SimpleWeightedGraphPoint(Class<? extends ChargedEdge> edgeClass) {
		super(edgeClass);
	}
/* to print out the graph */
	public String toPrint(){
		String s = new String();
		
		for (Iterator<PointLabeled> iterator = this.vertexSet().iterator(); iterator.hasNext();) {
			PointLabeled p = (PointLabeled) iterator.next();
			s = s.concat("(" + p.x + "," + p.y + "," + p.getLabel() + ") ");			
		}
		s = s.concat("\n");
		
		for (Iterator<ChargedEdge> iterator = this.edgeSet().iterator(); iterator.hasNext();) {
			ChargedEdge dwe = (ChargedEdge) iterator.next();
			s = s.concat("(" + 
					(getEdgeSource(dwe)).x + "," + (getEdgeSource(dwe)).y + "," + getEdgeSource(dwe).getLabel() +
					") - (" + 
					(getEdgeTarget(dwe)).x + "," + (getEdgeTarget(dwe)).y + "," + getEdgeTarget(dwe).getLabel() +
					")    " +
					getEdgeWeight(dwe) + "\n");
		}
		
		System.out.print(s);
		return s;
	}
/* to read in the graph from file "InputGraph" */
	public void readInputGraph() throws FileNotFoundException {
		
		Scanner sc = new Scanner(new File("InputGraph"));
		
		int scNext1 = Integer.parseInt(sc.next());
        int scNext2 = Integer.parseInt(sc.next());
        double scNext3 = Double.parseDouble(sc.next());
        sc.next();
        
		for (int i = 0; i < scNext2; i++) {
			this.addVertex(new PointLabeled(i,i,new String(""+i)));
		}
        
		
        while (sc.hasNext()) {
	          scNext1 = Integer.parseInt(sc.next());
	          scNext2 = Integer.parseInt(sc.next());
	          scNext3 = Double.parseDouble(sc.next());
	          sc.next();
	          ChargedEdge edge2add = this.
	        		  addEdge(new PointLabeled(scNext1,scNext1,new String(""+scNext1)), 
	        				  new PointLabeled(scNext2,scNext2,new String(""+scNext2)));
		      if (edge2add != null) {
		    	  this.setEdgeWeight(edge2add, scNext3);
			}
	          
		}
	}

	public void readInputTree() throws FileNotFoundException {
		
		Scanner sc = new Scanner(new File("InputGraph"));
		
		int scNext1 = Integer.parseInt(sc.next());
        int scNext2 = Integer.parseInt(sc.next());
        double scNext3 = Double.parseDouble(sc.next());
        int scNext4 = Integer.parseInt(sc.next());
        
		for (int i = 0; i < scNext2; i++) {
			this.addVertex(new PointLabeled(i,i,new String(""+i)));
		}
        
		
        while (sc.hasNext()) {
	          scNext1 = Integer.parseInt(sc.next());
	          scNext2 = Integer.parseInt(sc.next());
	          scNext3 = Double.parseDouble(sc.next());
	          scNext4 = Integer.parseInt(sc.next());
	          if (scNext4 == 1){
	        	  ChargedEdge edge2add = this.
	        			  addEdge(new PointLabeled(scNext1,scNext1,new String(""+scNext1)), 
	        					  new PointLabeled(scNext2,scNext2,new String(""+scNext2)));
	        	  if (edge2add != null) {
	        		  this.setEdgeWeight(edge2add, scNext3);
	        	  }
	          }
	          
		}
	}

	public String getDName(ChargedEdge e, PointLabeled p) {
		String s = new String(
				"d(" + this.getEdgeSource(e).getLabel() +
				","  + this.getEdgeTarget(e).getLabel() +
				")," + p.getLabel());
		return s;		
	}
	
	public String getWName(ChargedEdge e) {
		String s = new String(
				"w(" + this.getEdgeSource(e).getLabel() +
				","  + this.getEdgeTarget(e).getLabel() +
				")");
		return s;		
	}
	
	public String getGName(ChargedEdge e) {
		String s = new String(
				"g(" + this.getEdgeSource(e).getLabel() +
				","  + this.getEdgeTarget(e).getLabel() +
				")");
		return s;		
	}
	
	public String getCName(ChargedEdge e) {
		String s = new String(
				"c(" + this.getEdgeSource(e).getLabel() +
				","  + this.getEdgeTarget(e).getLabel() +
				")");
		return s;		
	}
	
	public String getName(ChargedEdge e) {
		String s = new String(
				"(" + this.getEdgeSource(e).getLabel() +
				","  + this.getEdgeTarget(e).getLabel() +
				")");
		return s;		
	}
	
	public PointLabeled getPointByLabel(String label) {
		for (Iterator<PointLabeled> iterator = this.vertexSet().iterator(); iterator.hasNext();) {
			PointLabeled p = (PointLabeled) iterator.next();
			if (p.getLabel().equals(label)) return p;			
		}
		return null;
	}

	public void divideTrees(ChargedEdge e, List<PointLabeled> pSet1, List<PointLabeled> pSet2) {
		pSet1.add(this.getEdgeSource(e));
		pSet2.add(this.getEdgeTarget(e));
		
		boolean toContinue = true;
		
		while (toContinue) {
			toContinue = false;
			
			for (Iterator<PointLabeled> it = this.vertexSet().iterator(); it.hasNext();) {
				PointLabeled p = (PointLabeled) it.next();
				
				boolean inSet1 = false,
						inSet2 = false;
				
				if (pSet1.contains(p) == true || pSet2.contains(p) == true) continue;
				
				for (Iterator<PointLabeled> it1 = pSet1.iterator(); it1.hasNext();) {
					PointLabeled p1 = (PointLabeled) it1.next();
					
					if (this.getEdge(p, p1) != null) {
						pSet1.add(p);
						inSet1 = true;
						break;
					}
				}
				
				if (inSet1 == true) continue;
				
				for (Iterator<PointLabeled> it2 = pSet2.iterator(); it2.hasNext();) {
					PointLabeled p2 = (PointLabeled) it2.next();
					
					if (this.getEdge(p, p2) != null) {
						pSet2.add(p);
						inSet2 = true;
						break;
					}
				}
				
				if (inSet2 == false) toContinue = true;
			}
		}
	}

	public void readFromFile(int isTree) throws FileNotFoundException {
		
		this.removeAllEdges(this.edgeSet());
		this.removeAllVertices(this.vertexSet());
		
		Scanner sc = null;
		if (isTree == 1) sc = new Scanner(new File("/Users/Logsiny/Documents/workspace/Gap/InputT"));
		else sc = new Scanner(new File("/Users/Logsiny/Documents/workspace/Gap/InputG"));
		
		int v = sc.nextInt();
		
		//calculate coordinates
		int[] x = new int[v];
		int[] y = new int[v];
		//...
		for (int i=0;i<v;i++) {
			x[i] = center.x + (int)(radius * Math.cos(2 * Math.PI * (double)i/v));
			y[i] = center.y + (int)(radius * Math.sin(2 * Math.PI * (double)i/v));
		}
				
		for (int i=0;i<v;i++) {
			this.addVertex(new PointLabeled(x[i], y[i], new String(""+(i+1))));
		}
		
		sc.useDelimiter("[\\p{Punct}\\s\\p{Alpha}]+");
		/*
		while (sc.hasNext())
			System.out.println("sb "+sc.next());
		*/
		while (sc.hasNext()) {
			
			int v1 = Integer.parseInt(sc.next());
			int v2 = Integer.parseInt(sc.next());
			
			this.addEdge(this.getPointByLabel(new String(""+v1)), this.getPointByLabel(new String(""+v2)));
		}
		
		this.toPrint();
	}
}

