package gap.graph.cal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;

import gap.graph.ChargedEdge;
import org.jgrapht.graph.GraphPathImpl;

import lpsolve.LpSolve;
import lpsolve.LpSolveException;
import gap.graph.PointLabeled;
import gap.graph.SimpleWeightedGraphPoint;
import gap.graph.layout.editor;

public class gapSolve {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		editor ed = new editor();
		ed.init();
	}
	
	public static LpSolve makeGapLp(SimpleWeightedGraphPoint g,SimpleWeightedGraphPoint t) throws LpSolveException{
		int gen = g.edgeSet().size();
		int ten = t.edgeSet().size();
		int vn  = g.vertexSet().size();
		
		int vars = gen + gen + (gen - ten)*vn;
		int constrs = 0;
		
		LpSolve lp = LpSolve.makeLp(constrs,vars);
		
		//set names for columns
		int i = 1;
		Iterator<ChargedEdge> it = g.edgeSet().iterator();
		for (; i <= gen; i++) {
			
			ChargedEdge e = (ChargedEdge) it.next();
			lp.setColName(i,     new String("g(" + g.getEdgeSource(e).getLabel() +
					"," + g.getEdgeTarget(e).getLabel() + ")"));
			lp.setColName(i+gen, new String("w(" + g.getEdgeSource(e).getLabel() +
					"," + g.getEdgeTarget(e).getLabel() + ")"));
		}
		i = 2*gen + 1;
		for (Iterator<ChargedEdge> iterator_gt = g.edgeSet().iterator(); iterator_gt.hasNext();) {
			ChargedEdge egt = (ChargedEdge) iterator_gt.next();
			if (t.containsEdge(g.getEdgeSource(egt), g.getEdgeTarget(egt)) != true) {
				for (Iterator<PointLabeled> iterator_p = g.vertexSet().iterator(); iterator_p.hasNext();) {
					PointLabeled p = (PointLabeled) iterator_p.next();
					lp.setColName(i++,new String(
							"d(" + g.getEdgeSource(egt).getLabel() + 
							","  + g.getEdgeTarget(egt).getLabel() + 
							")," + p.getLabel()));
				}
			}
		}
		
		//set rows
		int rowindex = 1;
		double[] row = new double[ten];
		int[] colno = new int[ten];
		
		//w(T) <= 1
		int j = gen, k = 0;
		for (Iterator<ChargedEdge> iterator = g.edgeSet().iterator(); iterator.hasNext(); j++) {
			ChargedEdge e = (ChargedEdge) iterator.next();
			if (t.containsEdge(g.getEdgeSource(e), g.getEdgeTarget(e)) == true) {
				colno[k] = j + 1;
				row[k] = 1;
				k++;
			}
		}
		lp.addConstraintex(ten, row, colno, LpSolve.LE, 1);
		lp.setRowName(rowindex++, new String("w(T)"));
		
		j = 1; k =0;
		row = new double[3];
		colno = new int[3];
		/* g(u,v) <= d(u,v),v - w(u,v)
		   d(u,v),u <= 0
		   for every (u,v) in G-T      */
		for (Iterator<ChargedEdge> iterator = g.edgeSet().iterator(); iterator.hasNext(); j++) {
			ChargedEdge e = (ChargedEdge) iterator.next();
			if (t.containsEdge(g.getEdgeSource(e), g.getEdgeTarget(e)) != true) {
				//for every e(u,v) in G-T
				//1. g(u,v) + w(u,v) - d(u,v),v <= 0
				colno[0] = j;
				colno[1] = gen + j;
				String s = new String(
						"d("+ g.getEdgeSource(e).getLabel() + 
						"," + g.getEdgeTarget(e).getLabel() + 
						")," + g.getEdgeTarget(e).getLabel());
				//System.out.println(s);
				colno[2] = lp.getNameindex(s, false);
				row[0] = 1;
				row[1] = 1;
				row[2] = -1;
				lp.addConstraintex(3, row, colno, LpSolve.LE, 0);
				String p = new String(
						"("+ g.getEdgeSource(e).getLabel() + 
						"," + g.getEdgeTarget(e).getLabel() + 
						")");
				lp.setRowName(rowindex++, new String(
						"g" + p +
						" + " + "w" + p +
						" - " + s));
				
				//2. d(u,v),u <= 0
				s = new String(
						"d("+ g.getEdgeSource(e).getLabel() + 
						"," + g.getEdgeTarget(e).getLabel() + 
						")," + g.getEdgeSource(e).getLabel());
				colno[0] = lp.getNameindex(s, false);
				row[0] = 1;
				lp.addConstraintex(1, row, colno, LpSolve.LE, 0);
				lp.setRowName(rowindex++, s);
			}
		}
		
		//d(u,v),y - d(u,v),x - w(x,y) <= 0, for every e=(u,v) in G-T and every (x,y) in G-e
		for (Iterator<ChargedEdge> iterator = g.edgeSet().iterator(); iterator.hasNext();) {
			ChargedEdge e = (ChargedEdge) iterator.next();
			if (t.containsEdge(g.getEdgeSource(e), g.getEdgeTarget(e)) != true) {
				//for every e=(u,v) in G-T
				for (Iterator<ChargedEdge> iterator2 = g.edgeSet().iterator(); 
						iterator2.hasNext();) {
					ChargedEdge eg = (ChargedEdge) iterator2.next();
					if (e != eg) {
						//for every (x,y) in G-e
						//1. d(u,v),y - d(u,v),x - w(x,y) <= 0
						colno[0] = lp.getNameindex(g.getDName(e, g.getEdgeTarget(eg)), false);
						colno[1] = lp.getNameindex(g.getDName(e, g.getEdgeSource(eg)), false);
						colno[2] = lp.getNameindex(g.getWName(eg),false);
						row[0] = 1;
						row[1] = -1;
						row[2] = -1;
						lp.addConstraintex(3, row, colno, LpSolve.LE, 0);
						lp.setRowName(rowindex++, new String(
								g.getDName(e, g.getEdgeTarget(eg)) + 
								" - " + g.getDName(e, g.getEdgeSource(eg)) +
								" - " + g.getWName(eg)));
						
						//2. d(u,v),x - d(u,v),y - w(x,y) <= 0
						colno[0] = lp.getNameindex(g.getDName(e, g.getEdgeSource(eg)), false);
						colno[1] = lp.getNameindex(g.getDName(e, g.getEdgeTarget(eg)), false);
						colno[2] = lp.getNameindex(g.getWName(eg),false);
						row[0] = 1;
						row[1] = -1;
						row[2] = -1;
						lp.addConstraintex(3, row, colno, LpSolve.LE, 0);
						lp.setRowName(rowindex++, new String(
								g.getDName(e, g.getEdgeSource(eg)) + 
								" - " + g.getDName(e, g.getEdgeTarget(eg)) +
								" - " + g.getWName(eg)));
					}
					
				}
			}
			
		}
		
		//constraints for MST
		row = new double[2];
		colno = new int[2];
		
		for (Iterator<ChargedEdge> im = t.edgeSet().iterator(); im.hasNext();) {
			ChargedEdge e = (ChargedEdge) im.next();
			ChargedEdge eG = g.getEdge(g.getEdgeSource(e), g.getEdgeTarget(e));
			
			List<PointLabeled> pSet1 = new ArrayList<PointLabeled>();
			List<PointLabeled> pSet2 = new ArrayList<PointLabeled>();
			
			t.divideTrees(e, pSet1, pSet2);
			
			for (Iterator<PointLabeled> it1 = pSet1.iterator(); it1.hasNext();) {
				PointLabeled p1 = (PointLabeled) it1.next();
				
				for (Iterator<PointLabeled> it2 = pSet2.iterator(); it2.hasNext();) {
					PointLabeled p2 = (PointLabeled) it2.next();
					
					if (g.containsEdge(p1, p2) && t.getEdge(p1, p2) != e){
						//add w(e) - w(p1,p2) <= 0
						colno[0] = lp.getNameindex(g.getWName(eG), false);
						colno[1] = lp.getNameindex(g.getWName(g.getEdge(p1,p2)), false);
						row[0] = 0;
						row[1] = 0;
						/*
						row[0] = 1;
						row[1] = -1;
						 */
						
						lp.addConstraintex(2, row, colno, LpSolve.LE, 0);
						lp.setRowName(rowindex++, new String(
								g.getWName(eG) + 
								" - " + g.getWName(g.getEdge(p1,p2))));
					}
				}
			}
			
		}
		
		//set object function
		row = new double[gen-ten];
		colno = new int[gen-ten];
		j = 1; k = 0;
		//max: sum(g_e) for every e:G-T
		for (Iterator<ChargedEdge> iterator = g.edgeSet().iterator(); iterator.hasNext(); j++) {
			ChargedEdge e = (ChargedEdge) iterator.next();
			if (t.containsEdge(g.getEdgeSource(e), g.getEdgeTarget(e)) != true) {
				//for every e=(u,v) in G-T
				colno[k] = j;
				row[k] = 1;
				k++;
			}
		}
		lp.setObjFnex(gen-ten, row, colno);
		lp.setMaxim();
		
		//lp.printLp();
		return lp;
	}

	public static GraphPathImpl<PointLabeled, ChargedEdge> 
		getShortestPath(LpSolve lp, SimpleWeightedGraphPoint g, SimpleWeightedGraphPoint t, 
				PointLabeled src, PointLabeled tgt) throws LpSolveException {
		
		List<ChargedEdge> edgelist = new ArrayList<ChargedEdge>();
		List<PointLabeled> vertexlist = new ArrayList<PointLabeled>();
		double weight = 0;
		
		double[] constrValue = lp.getPtrConstraints();
		double[] dualValue = lp.getPtrDualSolution();
		
		for (int i = 1; i < constrValue.length; i++) {
			System.out.print(dualValue[i] + " " + constrValue[i-1]);
			System.out.println();
		}
		
		ChargedEdge e0 = g.getEdge(src, tgt);
		PointLabeled ver = g.getEdgeTarget(e0);
		PointLabeled ver0 = g.getEdgeTarget(e0);
		int gen = g.edgeSet().size();
		int ten = t.edgeSet().size();
		char[] tmp = new char[8];
		PointLabeled p1 = null,p2 = null;
		int i;
		//boolean noFound = false;
		String dName = g.getDName(e0, ver);
		while (true) {
			vertexlist.add(ver);
			for (i = 1 + 2*(gen - ten); i <= constrValue.length; i++) {
				if (constrValue[i-1] == 0 && dualValue[i] != 0) {
					if (lp.getRowName(i).startsWith(dName) == true) {
						lp.getRowName(i).getChars(11, 19, tmp, 0);
						
						int d2 = Character.digit(tmp[2], 10);
						int d7 = Character.digit(tmp[7], 10);
						
						
						//p1 = new PointLabeled(d2, d2, new String(""+d2));
						//p2 = new PointLabeled(d7, d7, new String(""+d7));
						p1 = g.getPointByLabel(new String(""+d2));
						p2 = g.getPointByLabel(new String(""+d7));
						if (vertexlist.contains(p2)) continue;
						break;
					}
				}
			}
			/*
			if (i == constrValue.length + 1) {
				noFound = true;
				continue;
			}
			*/
			if (p2.getLabel().equals(g.getEdgeSource(e0).getLabel())) break;
			ver = (!(p2.getLabel().equals(g.getEdgeSource(e0).getLabel())) ? p2 : p1);
			dName = g.getDName(e0, ver);
		}
		vertexlist.add(g.getEdgeSource(e0));
		
		//Modify Vertices List
		int j = 1;
		List<PointLabeled> vertexlistModified = new ArrayList<PointLabeled>();
		while (true) {
			PointLabeled p = vertexlist.get(vertexlist.size()-j);
			vertexlistModified.add(p);
			if (p == ver0) break;
			j++;
		}
		
		System.out.print("The shortest path from "+src.getLabel()+" to "+tgt.getLabel()+" is through: ");
		for (Iterator<PointLabeled> it = vertexlistModified.iterator(); it.hasNext();) {
			PointLabeled p = (PointLabeled) it.next();
			System.out.print(p.getLabel()+" ");			
		}
		System.out.print("\n");
		
		PointLabeled p = null, q = null;
		Iterator<PointLabeled> is = vertexlistModified.iterator();
		if (is.hasNext()) {
			p = (PointLabeled) is.next();
		}
		if (is.hasNext()) {
			q = (PointLabeled) is.next();
		}
		
		while(true) {
			edgelist.add(g.getEdge(p, q));
			p = q;
			if (is.hasNext()) q = (PointLabeled) is.next();
			else break;			
		}
		
		for (Iterator<ChargedEdge> it = edgelist.iterator(); it.hasNext();) {
			ChargedEdge e = (ChargedEdge) it.next();
			System.out.println(g.getName(e));
		}
		
		GraphPathImpl<PointLabeled, ChargedEdge> path = 
				new GraphPathImpl<PointLabeled, ChargedEdge>(g, src, tgt, edgelist, weight);
		
		return path;
	}

	public static void getChargingScheme(LpSolve lp, SimpleWeightedGraphPoint g, SimpleWeightedGraphPoint t) throws LpSolveException{
		GraphPathImpl<PointLabeled, ChargedEdge> path = null;
		for (Iterator<ChargedEdge> it = g.edgeSet().iterator(); it.hasNext();) {
			ChargedEdge e = (ChargedEdge) it.next();
			if (t.getEdge(g.getEdgeSource(e), g.getEdgeTarget(e)) == null) {
				path = getShortestPath(lp,g,t,g.getEdgeSource(e), g.getEdgeTarget(e));
				g.setEdgeWeight(e, g.getEdgeWeight(e)-1);
				for (Iterator<ChargedEdge> itp = path.getEdgeList().iterator(); itp
						.hasNext();) {
					ChargedEdge ep = (ChargedEdge) itp.next();
					g.setEdgeWeight(ep, g.getEdgeWeight(ep)+1);
					
				}
			}
		}
		
		System.out.println("Charge List:");
		for (Iterator<ChargedEdge> it = g.edgeSet().iterator(); it.hasNext();) {
			ChargedEdge e = (ChargedEdge) it.next();
			System.out.println(g.getCName(e) + " " + g.getEdgeWeight(e));
		}
	}
	
	public static List<ChargedEdge> 
		getShortestFlow(LpSolve lp, SimpleWeightedGraphPoint g, SimpleWeightedGraphPoint t, 
				PointLabeled src, PointLabeled tgt) throws LpSolveException {
	
		List<ChargedEdge> edgelist = new ArrayList<ChargedEdge>();
	
		double[] constrValue = lp.getPtrConstraints();
		double[] dualValue = lp.getPtrDualSolution();
	
		ChargedEdge e0 = g.getEdge(src, tgt);

		int gen = g.edgeSet().size();
		int ten = t.edgeSet().size();
		//char[] tmp = new char[8];
	
		String Name = g.getName(e0);
	
		for (int i = 1 + 2*(gen - ten); i <= constrValue.length; i++) {
			if (constrValue[i-1] == 0 && dualValue[i] != 0) {
				if (lp.getRowName(i).startsWith("d" + Name) == true && lp.getRowName(i).length() > 27) {
					
					/*
					lp.getRowName(i).getChars(22, 28, tmp, 0);

					int d2 = Character.digit(tmp[2], 10);
					int d4 = Character.digit(tmp[4], 10);

					PointLabeled p1 = g.getPointByLabel(new String(""+d2));
					PointLabeled p2 = g.getPointByLabel(new String(""+d4));
					*/
					
					Scanner sc = new Scanner(lp.getRowName(i));
					//d(u,v),x - d(u,v),y - w(x,y)
					sc.useDelimiter("[\\p{Punct}\\s\\p{Alpha}]+");
					sc.next();
					sc.next();
					int dx = Integer.parseInt(sc.next());
					sc.next();
					sc.next();
					int dy = Integer.parseInt(sc.next());
					
					PointLabeled p1 = g.getPointByLabel(new String(""+dx));
					PointLabeled p2 = g.getPointByLabel(new String(""+dy));
					
					edgelist.add(g.getEdge(p1, p2));
					g.getEdge(p1, p2).setCharge(dualValue[i]);
				}
			}
		}		
		/*
		for (Iterator<ChargedEdge> iterator = edgelist.iterator(); iterator.hasNext();) {
			ChargedEdge chargedEdge = (ChargedEdge) iterator.next();
			
			System.out.println(g.getName(chargedEdge));
		}
		*/
		System.out.println();
		return edgelist;
	}

	
}
