package gap.graph.parse;

import gap.graph.GapSimpleWeightedGraph;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.*;

import org.jgrapht.graph.DefaultWeightedEdge;

public class GraphFile {

	public GraphFile() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param args
	 * @throws FileNotFoundException 
	 */
	public static void main(String[] args){
		try {
			GapSimpleWeightedGraph<String, DefaultWeightedEdge> gr = readInputGraph();
			gr.toPrint();
			gr.reduceWeight();
			gr.toPrint();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	/* read in graph file */
	public static GapSimpleWeightedGraph<String, DefaultWeightedEdge> readInputGraph() throws FileNotFoundException {
		GapSimpleWeightedGraph<String, DefaultWeightedEdge> g =
	            new GapSimpleWeightedGraph<String, DefaultWeightedEdge>(DefaultWeightedEdge.class);
		
		Scanner sc = new Scanner(new File("InputGraph"));
		
		String scNext1 = sc.next();
        String scNext2 = sc.next();
        String scNext3 = sc.next();
        
		String[] vertex2add = new String[Integer.parseInt(scNext2)];
		for (int i = 0; i < vertex2add.length; i++) {
			vertex2add[i] = "v"+i;				
			g.addVertex(vertex2add[i]);
		}
        
		
        while (sc.hasNext()) {
	          scNext1 = sc.next();
	          scNext2 = sc.next();
	          scNext3 = sc.next();
	          //System.out.println(scNext1+scNext2+scNext3);
	          DefaultWeightedEdge edge2add = g.addEdge(vertex2add[Integer.parseInt(scNext1)], vertex2add[Integer.parseInt(scNext2)]);
		      if (edge2add != null) {
		    	  g.setEdgeWeight(edge2add, Double.parseDouble(scNext3));
			}
	          
		}
	    System.out.println(g.toString());
	    
	    return g;
		
	}
	 
}
