package gap.graph.layout;

import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.*;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.List;

import lpsolve.LpSolve;
import lpsolve.LpSolveException;

import gap.graph.ChargedEdge;
import org.jgrapht.graph.GraphPathImpl;

import gap.graph.*;
import gap.graph.cal.gapSolve;

public class editor extends Applet implements Runnable, MouseListener, KeyListener{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private static final int SIZE = 10;
	private TextField text;
	private int X,Y;
	private PointLabeled start,end,t_start,t_end,e_start,e_end;
	private PointLabeled empty = new PointLabeled(0,0);
	private Thread t;
	private SimpleWeightedGraphPoint g,tree;
	private LpSolve lp;
	private int label_count;
	private String str = "";
	private int rf = 0;
	private GraphPathImpl<PointLabeled, ChargedEdge> path;
	private boolean updated = true;
	private	boolean updatedFlow = true;
	private List<ChargedEdge> flow;

 	public editor() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// initialize the editor interface
		editor ed = new editor();
		ed.init();
	}
	
	public SimpleWeightedGraphPoint getGraph(){
		return g;
	}
	
	public SimpleWeightedGraphPoint getTree(){
		return tree;
	}
	
	public void init(){
		text = new TextField(100); 
        //add(text);
        g = new SimpleWeightedGraphPoint(ChargedEdge.class);
        tree = new SimpleWeightedGraphPoint(ChargedEdge.class);
        addMouseListener(this);
        addKeyListener(this);
        this.setFocusable(true);
        X = 0;
        Y = 0;
        start = empty;
        end = empty;
        t_start = empty;
        t_end = empty;
        e_start = empty;
        e_end = empty;
        t = new Thread(this);
        t.start();
	}
	
	public void paint(Graphics gra){
		if (X != 0 || Y != 0) {
			gra.fillRect(X-SIZE/2,Y-SIZE/2,SIZE,SIZE);
		}
		if ((start != empty) && (end != empty)) {
			gra.drawLine(start.x, start.y, end.x, end.y);
			start = empty;
			end = empty;
		}
		gra.setColor(Color.RED);
		if ((t_start != empty) && (t_end != empty)) {
			gra.drawLine(t_start.x, t_start.y, t_end.x, t_end.y);
			t_start = empty;
			t_end = empty;
		}
		gra.setColor(Color.YELLOW);
		if ((e_start != empty) && (e_end != empty)) {
			gra.drawLine(e_start.x, e_start.y, e_end.x, e_end.y);
			e_start = empty;
			e_end = empty;
		}
		gra.setColor(Color.GREEN);
		if (updated == false) {
			for (Iterator<ChargedEdge> it = path.getEdgeList().iterator(); it.hasNext();) {
				ChargedEdge e = (ChargedEdge) it.next();
				gra.drawLine(g.getEdgeSource(e).x, g.getEdgeSource(e).y,
						g.getEdgeTarget(e).x, g.getEdgeTarget(e).y);
			}
			updated = true;
		}
		gra.setColor(Color.BLUE);
		if (updatedFlow == false) {
			for (Iterator<ChargedEdge> it = flow.iterator(); it.hasNext();) {
				ChargedEdge e = (ChargedEdge) it.next();
				((Graphics2D)gra).setStroke(new BasicStroke((float) (6 * e.getCharge())));
				gra.drawLine(g.getEdgeSource(e).x, g.getEdgeSource(e).y,
						g.getEdgeTarget(e).x, g.getEdgeTarget(e).y);
				System.out.println(g.getName(e)+e.getCharge());
			}
			updatedFlow = true;
		}
		
		
		if (rf == 1) refresh(gra);
	}
	
	public void update(Graphics gra){
		if (rf == 1) super.update(gra);
		else paint(gra);
	}
	
	public void refresh(Graphics gra){
		
		for (Iterator<PointLabeled> iterator = g.vertexSet().iterator(); iterator.hasNext();) {
			PointLabeled p = (PointLabeled) iterator.next();
			
			gra.setColor(Color.BLACK);
			gra.fillRect(p.x-SIZE/2,p.y-SIZE/2,SIZE,SIZE);
		}
		
		for (Iterator<ChargedEdge> it = g.edgeSet().iterator(); it.hasNext();) {
			ChargedEdge e = (ChargedEdge) it.next();
			if (tree.getEdge(g.getEdgeSource(e), g.getEdgeTarget(e)) != null) {
				gra.setColor(Color.RED);
				gra.drawLine(g.getEdgeSource(e).x, g.getEdgeSource(e).y,
						g.getEdgeTarget(e).x, g.getEdgeTarget(e).y);
			}
			else {
				gra.setColor(Color.BLACK);
				gra.drawLine(g.getEdgeSource(e).x, g.getEdgeSource(e).y,
						g.getEdgeTarget(e).x, g.getEdgeTarget(e).y);
			}
			
		}
		rf = 0;
	}
	
	public PointLabeled findVertex(int x,int y){
		for (Iterator<PointLabeled> iterator = g.vertexSet().iterator(); iterator.hasNext();) {
			PointLabeled p = (PointLabeled) iterator.next();
			if (p.x-SIZE/2 < x && x < p.x+SIZE/2 && p.y-SIZE/2 < y && y < p.y+SIZE/2){
				return p;
			}
		}
		return null;
	}

	@Override
	public void mouseClicked(MouseEvent e) {
		// TODO Auto-generated method stub
		if(e.getClickCount() == 2){
			X = e.getX();
			Y = e.getY();
			PointLabeled p = new PointLabeled(X,Y, new String(""+ label_count++));
			g.addVertex(p);
			tree.addVertex(p);
			text.setText(g.toPrint());
			tree.toPrint();
		}
	}

	@Override
	public void mouseEntered(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseExited(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mousePressed(MouseEvent e) {
		// TODO Auto-generated method stub
		PointLabeled fV;
		if (str == "") {
			if (e.getButton() == MouseEvent.BUTTON1){
				if ((fV = findVertex(e.getX(),e.getY())) != null) {
					start = fV;
				}
			} else {
				start = empty;
			}
			if (e.getButton() == MouseEvent.BUTTON3){
				if ((fV = findVertex(e.getX(),e.getY())) != null) {
					t_start = fV;
				}
			} else {
				t_start = empty;
			}
		}
		else {
			//show the detour
			if (e.getButton() == MouseEvent.BUTTON1){
				if ((fV = findVertex(e.getX(),e.getY())) != null) {
					e_start = fV;
				}
			}
			else e_start = empty;
		}
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		// TODO Auto-generated method stub
		PointLabeled fV;
		if (str == "") {
			if (e.getButton() == MouseEvent.BUTTON1){
				if ((fV = findVertex(e.getX(),e.getY())) != null) {
					end = fV;
					if (start != empty) {
						g.setEdgeWeight(g.addEdge(start, end),0);
						g.toPrint();
					}
				}
			} else {
				end = empty;
			}
			if (e.getButton() == MouseEvent.BUTTON3){
				if ((fV = findVertex(e.getX(),e.getY())) != null) {
					t_end = fV;
					if (t_start != empty) {
						tree.setEdgeWeight(tree.addEdge(t_start, t_end),0);
						tree.toPrint();
					}
				}
			} else {
				t_end = empty;
			}
		}
		else if (str == "c"){
			//show the detour
			if (e.getButton() == MouseEvent.BUTTON1){
				if ((fV = findVertex(e.getX(),e.getY())) != null) {
					e_end = fV;
				}
			}
			else e_end = empty;
			if (e_start != empty && e_end != empty) {
				try {
					path = gapSolve.getShortestPath(lp,g,tree,e_start,e_end);
					updated = false;
				} catch (LpSolveException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
			}
		}
		else if (str == "s"){
			//show the detour
			if (e.getButton() == MouseEvent.BUTTON1){
				if ((fV = findVertex(e.getX(),e.getY())) != null) {
					e_end = fV;
				}
			}
			else e_end = empty;
			if (e_start != empty && e_end != empty) {
				try {
					flow = gapSolve.getShortestFlow(lp,g,tree,e_start,e_end);
					updatedFlow = false;
				} catch (LpSolveException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
			}
		}
	}

	@Override
	public void run() {
		// TODO Auto-generated method stub
		try{
			while(true){
				// Request repaint
				repaint();
                Thread.sleep(200);
            }
		}
		catch(Exception e){
		}
	}

	@Override
	public void keyPressed(KeyEvent arg0) {
		if (arg0.getKeyCode() == KeyEvent.VK_CONTROL) {
			str = "c";
		}
		if (arg0.getKeyCode() == KeyEvent.VK_SHIFT) {
			str = "s";
		}
		
	}

	@Override
	public void keyReleased(KeyEvent arg0) {
		str = "";
		//System.out.println(arg0.getKeyChar());
		if (arg0.getKeyChar() == 'e') {
			//System.out.println("input e");
		
			try {
				lp = gapSolve.makeGapLp(g,tree);
				System.out.println("done!");
			} catch (LpSolveException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if (arg0.getKeyChar() == 'p') {
			//lp.printObjective();
			lp.printSolution(1);
			//lp.printConstraints(1);
			//lp.printDuals();
			try {
				double[] dual = lp.getPtrDualSolution();
				for (int i=1;i<dual.length;i++) {
					if (dual[i] != 0) {
						System.out.println(lp.getRowName(i-1) + " = " + dual[i]);
					}
				}
			} catch (LpSolveException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
					
		if (arg0.getKeyChar() == 's')
			try {
				lp.solve();
				System.out.println("done!");
			} catch (LpSolveException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		
		if (arg0.getKeyChar() == 'b') 
			rf = 1;
		
		if (arg0.getKeyChar() == 'c')
			try {
				gapSolve.getChargingScheme(lp,g,tree);
			} catch (LpSolveException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		
		if (arg0.getKeyChar() == 'g') {
			//System.out.println("sb");
			try {
				g.readFromFile(0);
			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
		if (arg0.getKeyChar() == 't') {
			//System.out.println("sb");
			try {
				tree.readFromFile(1);
			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}

	@Override
	public void keyTyped(KeyEvent arg0) {
		// TODO Auto-generated method stub
		
	}

}
