package gap.graph.layout;

import gap.graph.PointLabeled;
import gap.graph.SimpleWeightedGraphPoint;
import gap.graph.cal.gapSolve;

import java.io.IOException;
import java.util.Scanner;

import lpsolve.LpSolve;
import lpsolve.LpSolveException;

import gap.graph.ChargedEdge;

public class readInput {

	/**
	 * @param args
	 * @throws LpSolveException 
	 * @throws IOException 
	 */
	public static void main(String[] args) throws LpSolveException, IOException {
		
		SimpleWeightedGraphPoint g = new SimpleWeightedGraphPoint(ChargedEdge.class);
		SimpleWeightedGraphPoint t = new SimpleWeightedGraphPoint(ChargedEdge.class);
		/*
		g.readInputGraph();
		g.toPrint();
		t.readInputTree();
		t.toPrint();
		*/
		g.readFromFile(0);
		t.readFromFile(1);
		LpSolve lp = gapSolve.makeGapLp(g,t);
		lp.solve();
		//lp.printObjective();
		
		//lp.printConstraints(1);
		//lp.printDuals();
		//lp.printObjective();
		lp.printSolution(1);
		
		Scanner sc = new Scanner(System.in);
		System.out.print("input two points: ");
		int j = Integer.parseInt(sc.next());
		int k = Integer.parseInt(sc.next());
		PointLabeled p1 = new PointLabeled(j,j,new String(""+j));
		PointLabeled p2 = new PointLabeled(k,k,new String(""+k));
		System.out.println("j = " + j + ", k = " + k);
		/*
		DijkstraShortestPath<PointLabeled, ChargedEdge> dijk = 
				new DijkstraShortestPath<PointLabeled, ChargedEdge>(g,p1,p2);
		//DijkstraShortestPath.findPathBetween(g,p1,p2);
		List<PointLabeled> l = Graphs.getPathVertexList(dijk.getPath());
		for (Iterator<PointLabeled> iterator = l.iterator(); iterator.hasNext();) {
			PointLabeled p = (PointLabeled) iterator.next();
			System.out.println(p.getLabel());
			
		}
		*/
		//gapSolve.getShortestPath(lp,g,t,p1,p2);
		//gapSolve.getChargingScheme(lp, g, t);
		
		
		
	}

}
