% Wiener
T = 1;
a = 0.05 - 0.15*0.15/2
b = 0.15;
dt = linspace(0,T,101)';
x1 = a * dt;
dz = zeros(length(dt),1);
for i = 1:101
dz(i) = normrnd(0,0.01);
end
x2 = b * dz;
dx = x1 + x2;
plot(dt,x1,'--',dt,x2,'-',dt,dx,'k-')
xlabel('T'),ylabel('stock price')
legend('general growth: mu*dt','Brownian motion: sigma*dB',...
    'generalized: dLogS = mu*dt + sigma*dB')
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Poisson
lambda = 20;
T = 1;
N = poissrnd(lambda);
X = zeros(N,1);
t = zeros(N,1);
b = 3;
sumT = 0;
for i = 1:(N-1)
    U = unifrnd(0,1);
    Y = normrnd(0,1);
    t(i+1)=t(i)-log(U)/10;
    X(i+1)=b*t(i+1) + Y;
    %sumT = sumT + t(i+1);
   
    if t(i+1)>=T
       break
    end
end
for i = 1:(N-1)
    Xt(2*i-1) = X(i+1);
    Xt(2*i) = X(i+1);
end
stairs(Xt)
xlabel('time t'),ylabel('X')


T = 1;
M = 50;
N = 100;
sigma = 0.15;
r = 0.05;

S0 = 100;
K = 100;

l = zeros(5,1);
bs = zeros(5,1);

% Changing M
Ms = linspace(50,170,5)';
Ao = 8;
vol = zeros(5,1);
for i = 1:5
    [l(i),bs(i)] = LevyMerton(Ao, T, Ms(i),N,S0,K,sigma,r,1);
    vol(i) = blsimpv(S0, K, r, T, l(i),[],[],[],false);
end
error = abs(vol-sigma)/sigma;

subplot(1,2,1), semilogy(Ms, error)
xlabel('size of M')
ylabel('implied volatility error in %')
subplot(1,2,2), plot(Ms,l)
xlabel('size of M')
ylabel('the put price')

% size of N
T = 1;
M = 50;
N = 100;
sigma = 0.15;
r = 0.05;

S0 = 100;
K = 100;

l = zeros(5,1);
bs = zeros(5,1);
Ns = linspace(10,130,5)';
Ao = 10;
vol = zeros(5,1);
for i = 1:5
    [l(i),bs(i)] = LevyMerton(Ao, T, M,Ns(i),S0,K,sigma,r,1);
    vol(i) = blsimpv(S0, K, r, T, l(i),[],[],[],false);
end
error = abs(vol-sigma)/sigma;
subplot(1,2,1), semilogy(Ns, error)
xlabel('size of N')
ylabel('implied volatility error in %')
subplot(1,2,2), plot(Ns,l)
xlabel('size of N')
ylabel('the put price')

% order of A
T = 1;
M = 50;
N = 100;
sigma = 0.15;
r = 0.05;

S0 = 100;
K = 100;

l = zeros(20,1);
bs = zeros(20,1);

for i = 3:(2+length(l))
    Ao = i;
    [l(i-2),bs(i-2)] = LevyMerton(Ao, T, M,N,S0,K,sigma,r,1);
    myFun = @(x) x .* x .* (0.1 * exp(-x .* x * 0.5) / sqrt(2*pi));
    A(i-1) = Ao * sqrt(T * (sigma * sigma + quadgk(myFun,-inf, inf)));
end

vol = zeros(length(l),1);
for i = 1:16
    vol(i) = blsimpv(S0, K, r, T, l(i),[],[],[],false);
end

error = abs(vol-sigma)/sigma;
subplot(1,2,1), semilogy(linspace(3,22,20)', vol)
xlabel('the order of A')
ylabel('implied volatility')
subplot(1,2,2), plot(linspace(3,22,20)',l)
xlabel('the order of A')
ylabel('the put price')

% Compare to the Black-Scholes Model
T = 1;
M = 80;
N = 100;
sigma = 0.15;
r = 0.05;
S0 = 100;
K = 100;
Ao = linspace(5,15,11)';
for i = 1:11
    [put(i),bs(i)] = LevyMerton(Ao(i),T,M,N,S0,K,sigma,r,1);
end
plot(Ao,put,Ao,bs,'--')
ylabel('the put price'),xlabel('order of A')
legend('by Levy','by Black-Scholes')
%%%%%%
T = 1;
M = 80;
N = 100;
sigma = 0.15;
r = 0.05;
S0 = 100;
K = 95;
Ao = linspace(5,15,11)';
for i = 1:11
    [put(i),bs(i)] = LevyMerton(Ao(i),T,M,N,S0,K,sigma,r,1);
end
plot(Ao,put,Ao,bs,'--')
ylabel('the put price'),xlabel('order of A')
legend('by Levy','by Black-Scholes')