function [ D ] = BuildD( sigma, dx, dt, r, N, alpha, lambda )
%
%   function BuildD
%
%   This function constructs the matrix D we use to pair with the
%   u_n+1. And, we scale it by (I + dt*D). To computational purpose,
%   we keep this matrix sparce; since it is tri-diagonal and asymmetric, 
%   we will use iterative methods such as GMRES to solve this problem.
%   
%   Input:  sigma: the volatility constant
%           dx: increment in step
%           dt: increment in time
%           r: risk-free rate
%           n: size of the matrix
%           alpha: coefficient for first order derivative
%
%   Output: D: nxn desired sparce matrix
%

C = sigma * sigma / (2 * (dx * dx)) - (1/dx) * (sigma*sigma/2 - r + alpha);
B = sigma*sigma / (dx*dx) + (1/dx) * (sigma*sigma/2 - r + alpha) + lambda;
A = sigma * sigma / (2 * dx * dx);

v1 = A * ones(N, 1);
v2 = - B * ones(N+1, 1);
v3 = C * ones(N, 1);

Diag = [[v1;0], v2, [0;v3]];
D = speye(N+1, N+1) - dt * spdiags(Diag, [-1,0,1], N+1, N+1);

end