%2(a)
n = 256;
x = linspace(0,1,n+2);
y = linspace(0,1,n+2);
x = x(2:(n+1));
y = y(2:(n+1));
[X,Y]= meshgrid(x,y);
u = 10 * X .* Y .* (1 - X) .* (1 - Y) .* exp(X);
c=0;
d=0;
X2 = X.*X;
Y2 = Y.*Y;
f = (3-c-2*d)*X .*Y+(-3+c)*X .*Y2+(1-c+2*d)*X2.*Y+(-1+c)*X2.*Y2;
f = f +(2+d)*X+(-2-d)*X2+c*Y-c*Y2;
f = 10 *f .*exp(X);
subplot(1,2,1), mesh(X,Y,u)
title('Plot of u(x,y)')
subplot(1,2,2), mesh(X,Y,f)
title('Plot of f(x,y)')

%------------------------------------------------------------------
%2(c)
F = reshape(f, n*n, 1);
h = 1/(n+2);
h2 = h*h;
b = F * h2;
U = reshape(u, n*n, 1);
n2 = n * n;
v1 = -ones(n2 - n, 1);
v2 = -ones(n2 - 1, 1);
v3 = 4 * ones(n2, 1);
v0 = zeros(n,1);
D = [[v1;v0],[v2;0],v3,[0;v2],[v0;v1]];
A = spdiags(D,[-n,-1,0,1,n],n2,n2);

tol = 1e-8;
maxit = 866;
[u_cap, flag, relres, iter, rv1] = pcg(A, b, tol, maxit);

%------------------------------------------------------------------
%2(d)
%opts.type = 'ict';
droptol = 0;
tic
M1 = cholinc(A, droptol);
toc;
% Elapsed time is 6.942427 seconds.

droptol = 0.1;
tic
M2 = cholinc(A, droptol);
toc;
% Elapsed time is 0.716711 seconds.

[u_cap2, flag2, relres, iter, rv2] = pcg(A, b, tol, maxit,M1',M1);
[u_cap3, flag3, relres, iter, rv3] = pcg(A, b, tol, maxit,M2',M2);

[m_rv2, n_rv2] = size(rv2);
rv2 = [rv2;zeros(maxit - m_rv2 +1,1)];
[m_rv3, n_rv3] = size(rv3);
rv3 = [rv3;zeros(maxit - m_rv3 +1,1)];
r = linspace(1, maxit, maxit+1);

%------------------------------------------------------------------
%2(e)
plot(r,rv1,r,rv2,r,rv3)
legend('no prec','0 droptol','0.1 droptol');

%------------------------------------------------------------------
%2(f)
U_cap = reshape(u_cap,256,256);
mesh(X,Y,U_cap);

%------------------------------------------------------------------
%3(a)
n = 256;
x = linspace(0,1,n+2);
y = linspace(0,1,n+2);
x = x(2:(n+1));
y = y(2:(n+1));
[X,Y]= meshgrid(x,y);
u = 10 * X .* Y .* (1 - X) .* (1 - Y) .* exp(X);
c=1;
d=20;
X2 = X.*X;
Y2 = Y.*Y;
f = 10*((3-c-2*d)*X .*Y+(-3+c)*X .*Y2+(1-c+2*d)*X2.*Y+(-1+c)*X2.*Y2...
    +(2+d)*X+(-2-d)*X2+c*Y-c*Y2).*exp(X);
subplot(1,2,1), mesh(X,Y,u)
title('Plot of u(x,y)')
subplot(1,2,2), mesh(X,Y,f)
title('Plot of f(x,y)')

%------------------------------------------------------------------
%3(b)
F = reshape(f, n*n, 1);
h = 1/(n+2);
h2 = h*h;
b = F * h2;
U = reshape(u, n*n, 1);
n2 = n * n;
v1 = -(1+20 * h) * ones(n2 - n, 1);
v2 = -(1+h) * ones(n2 - 1, 1);
v3 = (4+21 * h) * ones(n2, 1);
v4 = -ones(n2 - 1, 1);
v5 = -ones(n2 - n, 1);
v0 = zeros(n,1);
D = [[v1;v0],[v2;0],v3,[0;v4],[v0;v5]];
A2 = spdiags(D,[-n,-1,0,1,n],n2,n2);

%------------------------------------------------------------------
%3(c)
tol = 1e-8;
maxit = 645;
[u_cap,flag,relres,iter,resvec1] = gmres(A2,b,[],tol,maxit);

%------------------------------------------------------------------
%3(d)
setup.type = 'crout';
setup.droptol = 0;
tic
[L1,U1] = ilu(A2,setup);
toc;
%Elapsed time is 28.175844 seconds.

setup.type = 'crout';
setup.droptol = 0.1;
tic
[L2,U2] = ilu(A2,setup);
toc;
%Elapsed time is 18.173675 seconds.

[u_cap2, flag2, relres, iter, resvec2] = gmres(A2,b, [],tol, maxit,L1,U1);
[u_cap3, flag3, relres, iter, resvec3] = gmres(A2,b, [],tol, maxit,L2,U2);

[m_rv2, n_rv2] = size(resvec2);
resvec2 = [resvec2;zeros(maxit - m_rv2 +1,1)];
[m_rv3, n_rv3] = size(rv3);
resvec3 = [resvec3;zeros(maxit - m_rv3 +1,1)];
r = linspace(1, maxit, maxit+1);

%3(e)
plot(r,resvec1,r,resvec2,r,resvec3)
legend('no prec','0 droptol','0.1 droptol');

semilogy(r,resvec1,r,resvec2,r,resvec3)
title('plot with semilogy')
legend('no prec','0 droptol','0.1 droptol');

%-------------------------------------------------------------
%3(f)
[u_cap,flag,relres,iter,resvec1] = gmres(A2,b,10,tol,maxit);
[u_cap2, flag2, relres, iter, resvec2] = gmres(A2, b, 10, tol, maxit,L1,U1);
[u_cap3, flag3, relres, iter, resvec3] = gmres(A2, b, 10, tol, maxit,L2,U2);

[m_rv2, n_rv2] = size(resvec2);
resvec2 = [resvec2;zeros(length(resvec1) - m_rv2,1)];
[m_rv3, n_rv3] = size(resvec3);
resvec3 = [resvec3;zeros(length(resvec1) - m_rv3,1)];
r = linspace(1, length(resvec1), length(resvec1));

plot(r,resvec1,r,resvec2,r,resvec3)
legend('no prec','0 droptol','0.1 droptol')

semilogy(r,resvec1,r,resvec2,r,resvec3)
title('plot with semilogy')
legend('no prec','0 droptol','0.1 droptol');

%------------------------------------------------------------------
%3(g)
U_cap = reshape(u_cap,256,256);
mesh(X,Y,U_cap);