function [ u, C, flag ] = BuildU( A, T, M, N, Kl, Kr, sigma, r, hx, K, S0 )
%   function BuildU
%
%   This algorithm builds the vectors u_i one by one and compact
%   into a matrix u. First, we use function BuildD and BuildJ to
%   build left-hand and right-hand sides of this equation:
%               (I - dt*D) u_(n+1) = (I + dt*J) u_n.
%   Since this linear system involves large assymmetric and sparce
%   matrix on both sides, we use GMRES iteration to solve it.
%
%   Input:  A: truncated upper bound on x of the grid
%           T: maturity date
%           M: the number of subintervals of time
%           N: the number of subintervals of x movements
%           sigma: the volatility
%           r: risk-free rate
%           hx: vector of initial conditions
%
%   Output: u: a matrix containing u_i's as column vectors

% Initialization:
dt = T / M;
dx = 2*A / N;

u = zeros(N+1, M);
C = zeros(N+1, M);
u(:,1) = hx;
C(:,1) = u(:,1);

% build J and D.
[J, alpha, lambda] = BuildJ(N, dx, dt, Kl, Kr);
D = BuildD(sigma, dx, dt, r, N, alpha, lambda);

flag = zeros(M,1);
tao = 0;

for n = 1:M
    tao = tao + dt;
    b = J * u(:,n);
    [u(:,n+1), flag(n)] = gmres(D,b);
    C(:,n+1) = u(:, n+1) * exp(-r*tao) * K / S0;
end
end